<?php
/*
+ ----------------------------------------------------------------------------+
|     e107 website system
|
|     ¦Steve Dunstan 2001-2002
|     http://e107.org
|     jalist@e107.org
|
|     Released under the terms and conditions of the
|     GNU General Public License (http://gnu.org).
|
|     $Source: /cvsroot/e107/e107_0.7/e107_themes/gameplus/theme.php,v $
|     $Revision: 1.00 $
|     $Date: 2010/10/29 $
|     $Author: fizi $
+----------------------------------------------------------------------------+
*/
if (!defined('e107_INIT')) { exit; }
if (!defined("USER_WIDTH")){ define("USER_WIDTH","width:100%"); }

// [multilanguage]
include_lan(e_THEME."gameplus/languages/".e_LANGUAGE.".php");


// [theme]

$themename = "GamePlus";
$themeversion = "1.0";
$themeauthor = "fizi";
$themeemail = "fizi@wsb,hu";
$themewebsite = "http://fizi.wsb.hu";
$themedate = "23/02/2013";
$themeinfo = "";
$xhtmlcompliant = TRUE;	// If set to TRUE will display an XHTML compliant logo in theme manager
$csscompliant = TRUE;	// If set to TRUE will display a CSS compliant logo in theme manager

// Define which icon set to use.
// There are two possible values here 'dark' and 'lite'.
// If your theme has a light background then use 'lite' and vice versa for dark themes.
// Because IE does not yet support Alpha transparency with PNG24 images, all of e107's 
// icons have been saved with both a light and dark matte background (to prevent jagged 
// edges that you see when no matte is present).
// The IMODE is specifying which of the icon sets to use.
// IE7 will support Alpha transparent PNG's at which point we will create a third set
// of icons (using alpha transparency instead of a matte) and IMODE will gradually be 
// filtered out as this new set will work with all background colours.
// Uncomment the line below to define IMODE (remove the // ). Default is 'lite'.

define("IMODE", "lite");

// Theme disclaimer is displayed in your site disclaimer appended to the site disclaimer text.
// Uncomment the line below to set a theme disclaimer (remove the // ).

define("THEME_DISCLAIMER", "<br /><i>".LAN_THEME_6."</i>");

// Dont render core style sheet link.
// the contents of e107_files/e107.css have been copied to this themes style.css.
// By setting $no_core_css to TRUE below we can prevent the <link> tag 
// that would normally be generated in the <head> of the page from being outputted.
// This saves us a call by the browser to a stylesheet that we no longer need.

 $no_core_css = TRUE;

// Output into <head> section.
// Anything echoed from within the theme_head() function gets outputted into the <head> of your page.
// Please note that you have other choices for <head> based javascript. You can create a theme.js file 
// in your themes folder and a link will automatically be generated to it in the <head> of your page.
// If you have javascript that is independant of the theme rather than use theme.js or the theme_head()
// function below, its advisable to instead create a new file e107_files/user.js, placing your script 
// into this, and as with theme.js, a link will automatically be generated to this file.
// Uncomment the following three lines to use.

// function theme_head() {
// echo "<script></script>
// ";
// }


// Header and footer templates for the body of your site.
// These are the header and footer that wraps the content of a page.
// Note that these are the templates for *inbetween* the <body> and </body> tags. 
// The rest of the output (eg. the <head> section of the page) are covered by 
// the header and footer template files in e107_themes/templates.
// These are called header_default.php and footer_default.php.
// If you wish to use your own versions of these files uncomment the line below (remove the // ) 
// and edit it so that the text string represents the postfix of the new set of files.
// eg. using the example text e107 will include these files: 
// e107_themes/templates/header_your_version.php and e107_themes/templates/footer_your_version.php 
// instead of the default:
// e107_themes/templates/header_default.php and e107_themes/templates/footer_default.php 
// Please note however that using non default core header and footer templates is not recommended 
// and that the flexibility of these files enables you to add and edit content to them without editing 
// the files directly. Documentation for this can be found on e107.org.
 
// [Social Profiles]
$register_sc[]= 'SOCIAL';


// [Next and Prev button]
$register_sc[]= 'NEXTPREV';

// [layout]
$layout = "_default";


// Default layout
$HEADER = "
<div id='wrapper'>
  <div id='container'>
    <div class='clearfix'>
      <div class='menu-primary-container'>
        {SITELINKS_ALT=no_icons+noclick}
      </div>
      <div id='top-social-profiles'>
        {SOCIAL}
      </div>
    </div>
    <div id='header'>
      <div class='logo'>
        <h1 class='site_title'><a href='".e_HTTP."index.php' title='{SITENAME}'>{SITENAME}</a></h1>
        <h2 class='site_description'>{SITETAG}</h2>
      </div>
      <div class='header-right'>
        <div id='topsearch'>
          <div id='search'>
            {SEARCH}
          </div>
        </div>
      </div>
    </div>
    <div class='clearfix'>
      <div class='menu-secondary-container'>
        {LINKSTYLE=mainlinks2}
        {SITELINKS=flat:2}
      </div>
    </div>
    <div id='main'>
      <div id='content'>
        {SETSTYLE=centercol}
		    ";
$FOOTER =" 
      </div>
      <div id='sidebar-primary'>
        {SETSTYLE=leftcol}
        {MENU=1}
        {MENU=3}
      </div>
      <div id='sidebar-secondary'>
        {SETSTYLE=rightcol}
        {MENU=2}
        {MENU=4}
      </div>
    </div>
  </div>
</div>
<div id='footer-menus-container' class='clearfix'>
  <div id='footer-menus' class='clearfix'>
    <div class='footer-menu-box'>
      {SETSTYLE=bottomcol}
        {MENU=5}
    </div>
    <div class='footer-menu-box'>
      {SETSTYLE=bottomcol}
        {MENU=6}
    </div>
    <div class='footer-menu-box'>
      {SETSTYLE=bottomcol}
        {MENU=7}
    </div>
    <div class='footer-menu-box footer-menu-box-last'>
      {SETSTYLE=bottomcol}
        {MENU=8}
    </div>
  </div>
</div>
<div id='footer-container'> 
  <div id='footer'>
    <div id='copyrights'>
      {THEME_DISCLAIMER}
    </div>
    <div id='credits'>
      {SITEDISCLAIMER}
    </div>
  </div>
</div>       
";


// Full Width Layout
$CUSTOMHEADER['fullwidth'] = "
<div id='wrapper'>
  <div id='container'>
    <div class='clearfix'>
      <div class='menu-primary-container'>
        {SITELINKS_ALT=no_icons+noclick}
      </div>
      <div id='top-social-profiles'>
        {SOCIAL}
      </div>
    </div>
    <div id='header'>
      <div class='logo'>
        <h1 class='site_title'><a href='".e_HTTP."index.php' title='{SITENAME}'>{SITENAME}</a></h1>
        <h2 class='site_description'>{SITETAG}</h2>
      </div>
      <div class='header-right'>
        <div id='topsearch'>
          <div id='search'>
            {SEARCH}
          </div>
        </div>
      </div>
    </div>
    <div class='clearfix'>
      <div class='menu-secondary-container'>
        {LINKSTYLE=mainlinks2}
        {SITELINKS=flat:2}
      </div>
    </div>
    <div id='main-fullwidth'>
      <div id='content-fullwidth'>
        {SETSTYLE=centercol}
		    ";
$CUSTOMFOOTER['fullwidth'] =" 
      </div>
    </div>
  </div>
</div>
<div id='footer-menus-container' class='clearfix'>
  <div id='footer-menus' class='clearfix'>
    <div class='footer-menu-box'>
      {SETSTYLE=bottomcol}
        {MENU=5}
    </div>
    <div class='footer-menu-box'>
      {SETSTYLE=bottomcol}
        {MENU=6}
    </div>
    <div class='footer-menu-box'>
      {SETSTYLE=bottomcol}
        {MENU=7}
    </div>
    <div class='footer-menu-box footer-menu-box-last'>
      {SETSTYLE=bottomcol}
        {MENU=8}
    </div>
  </div>
</div>
<div id='footer-container'> 
  <div id='footer'>
    <div id='copyrights'>
      {THEME_DISCLAIMER}
    </div>
    <div id='credits'>
      {SITEDISCLAIMER}
    </div>
  </div>
</div>       
";

$CUSTOMPAGES['fullwidth'] ="forum/ calendar_menu/ content/ download.php submitnews.php";

function rand_tag(){
        $tags = file(e_BASE."files/taglines.txt");
        return stripslashes(htmlspecialchars($tags[rand(0, count($tags))]));
}


//        [newsstyle]
$NEWSSTYLE = "
  <div class='post'>
    <h2 class='title'>{NEWSTITLELINK=extend}</h2>
    <div class='postmeta-primary'>
      <span class='meta_date'>{NEWSDATE}</span>
      <span class='meta_categories'>".LAN_THEME_8."&nbsp;{NEWSCATEGORY}</span>
      <span class='meta_comments'>".LAN_THEME_1."&nbsp;{NEWSCOMMENTS}</span>
    </div>
    <div class='entry clearfix'>
      {NEWSIMAGE}
      <p>{NEWSBODY}</p>
    </div>
    <div class='readmore'>         
      {EXTENDED}    
    </div>       
  </div>
";
 
//  [list of news category]
$NEWSLISTSTYLE = "
<div class='post'>
  <h2 class='title'>{NEWSTITLELINK=extend}</h2>
  <div class='postmeta-primary'>
    <span class='meta_date'>{NEWSDATE}</span>
    <span class='meta_categories'>".LAN_THEME_8."&nbsp;{NEWSCATEGORY}</span>
    <span class='meta_comments'>".LAN_THEME_1."&nbsp;{NEWSCOMMENTS}</span>
  </div>
  <div class='entry clearfix'>
    {NEWSIMAGE}
    <p>{NEWSBODY}</p>
  </div>
  <div class='readmore'>         
    {EXTENDED}    
  </div>       
</div>
";


define('ICONPRINTPDF', 'pdf.png');
define('ICONMAIL', 'email.png');
define('ICONPRINT', 'printer.png');
define('ICONSTYLE', 'float: left; border:0');
define('COMMENTLINK', LAN_THEME_1);
define('COMMENTOFFSTRING', LAN_THEME_2);
define('PRE_EXTENDEDSTRING', '<div class="read-the-rest-button"><span>');
define('EXTENDEDSTRING', LAN_THEME_3);
define('POST_EXTENDEDSTRING', '</span></div><br />');
define('TRACKBACKSTRING', LAN_THEME_7);
define('TRACKBACKBEFORESTRING', '&nbsp;|&nbsp;');


// linkstyle
// http://wiki.e107.org/?title=Styling_Individual_Sitelink_Menus
function linkstyle($gameplus_linkstyle) {
// Common to all styles (for this theme)
// Common sublink settings
// NOTE: *any* settings can be customized for sublinks by using
//       'sub' as a prefix for the setting name. Plus, there's 'subindent'
//  $linkstyleset['sublinkclass'] = 'mysublink2;
//  $linkstyleset['subindent']    = ' ';
// Now for some per-style setup
  switch ($gameplus_linkstyle)
  {
  case 'mainlinks2':
  $linkstyleset['prelink'] =  "<ul class='menu-secondary'>";  // the html to use before the links are displayed
  $linkstyleset['postlink'] =  "</ul>";  // the html to use before the links are displayed
  $linkstyleset['linkclass'] =  "";  // the css class to apply to each link
  $linkstyleset['linkclass_hilite'] =  "";  // Current page highlights the corresponding menu-item
  $linkstyleset['linkstart'] =  "<li>";  // the html used before each link
//  $linkstyleset['linkstart_hilite'] =  ""; // Current page highlights the corresponding menu-item 
  $linkstyleset['linkend'] =  "</li>";  // the html used after each link
  $linkstyleset['linkdisplay'] = 1; // the link display mode
  $linkstyleset['linkalign'] =  "left";  // how the link should be aligned
  $linkstyleset['linkseperator'] =  "";
    break;
  default: // if no LINKSTYLE defined
  define('PRELINK', ""); // the html to use before the links are displayed
  define('POSTLINK', ""); // the html to use before the links are displayed
//  define('linkclass', ""); // the css class to apply to each link
//  define('linkclass_hilite', ""); // the css class to apply to the currently selected link
  define('LINKSTART', ""); // the html used before each link
//  define('LINKSTART_HILITE', " "); // Current page highlights the corresponding menu-item
  define('LINKEND', ""); // the html used after each link 
  define('LINKDISPLAY', 1); // the link display mode
  define('LINKALIGN', "left"); // how the link should be aligned
//  define('linkseperator', " ");
  }
return $linkstyleset;
}

define('BULLET', "bullet.png");
define('bullet', "bullet.png");



//        [tablestyle]
function tablestyle($caption, $text, $mode){
        global $style;
                        
        if($style == "centercol"){                  
          echo " 
            <div class='centermenu-box'>                             
              <div class='centermenu-box-title'>             		                                                      
                <h2>{$caption}</h2>
              </div>
              <div class='centermenu-box-body'>{$text}</div>
            </div>                                                                        
          "; 
        }else if($style == "leftcol"){                  
          echo "
            <div class='leftmenu-box'>
              <div class='leftmenu-box-title'>             		                                                      
                <h2>{$caption}</h2>
              </div>
              <div class='leftmenu-box-body'>{$text}</div>                                                     
            </div>                                                           
          ";
        }else if($style == "rightcol"){                  
          echo "
		        <div class='rightmenu-box'>
              <div class='rightmenu-box-title'>             		                                                      
                <h2>{$caption}</h2>
              </div>
              <div class='rightmenu-box-body'>{$text}</div>                                                     
            </div>                                                           
          ";         
        }else if($style == "bottomcol"){                  
          echo "
            <div class='footer-menu-box-title'>             		                                                      
              <h2>{$caption}</h2>
            </div>
            <div class='footer-menu-box-body'>{$text}</div>                                                                                                                
          ";                                   
        }else{
          echo "
            <div class='spacer'>	        
		          <div class='othermenu-box'>
		            <div class='othermenu-title'>         
                  <h2>{$caption}</h2>                  
                </div>		                                 
                <div class='othermenu-body'>{$text}</div>                               
              </div>
            </div>            
          ";        
        } 
}

// chatbox post style
$CHATBOXSTYLE = "<br />
<div style='text-align: left'>
<img src='".THEME_ABS."images/bullet3.png' alt='' style='width: 12px; height: 9px; vertical-align: middle' />
<b>{USERNAME}</b><br /><span class='smalltext'>{TIMEDATE}</span><br />{MESSAGE}</div>
";

// Image Version Example
$SEARCH_SHORTCODE = "
  <input class='search-box' type='text' name='q' size='20' value='".LAN_THEME_9."...' maxlength='50' onclick=\"this.value=''\" /> 
	<input class='search-button' type='image' name='s' src='".THEME_ABS."images/blank.gif'  value='".LAN_THEME_9."' style='width: 16px; height: 16px; border: 0px; vertical-align: middle'  />
  ";

?>